/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.util.Comparators;
import java.util.Comparator;
import java.util.Date;

public abstract class StoreActivity
extends Activity {
    private StoreType storeType;
    private Material material;
    private double qty;
    private static final Comparator<StoreActivity> TIME_QTY_REV_COMPARATOR = (o1, o2) -> {
        int res = Comparators.compare(o1.getTime(), o2.getTime());
        if (res == 0) {
            res = Comparators.compare(o2.getQty(), o1.getQty());
        }
        return res;
    };

    public StoreActivity(StoreType type, long time, Material material, double qty) {
        if (material == null) {
            throw new IllegalArgumentException("Material in StoreActivity must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type in StoreActivity must not be null.");
        }
        this.storeType = type;
        this.material = material;
        this.setQty(qty);
        this.setTime(time);
    }

    protected StoreActivity(StoreActivity other) {
        this.storeType = other.storeType;
        this.material = other.material;
        this.qty = other.qty;
        this.setTime(other.start);
    }

    public long getTime() {
        if (this.getStart() == this.getEnd()) {
            return this.getStart();
        }
        throw new IllegalStateException("If using get/setTime then setStart/End should not be used separately.");
    }

    public void setTime(long time) {
        if (time != this.getTime()) {
            this.setStartEnd(time, time);
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public double getAbsQty() {
        return Math.abs(this.qty);
    }

    public void setQty(double qty) {
        if (qty == 0.0) {
            throw new IllegalArgumentException("Store activity quantity must not be 0");
        }
        this.qty = qty;
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    public void setType(StoreType type) {
        this.storeType = type;
    }

    public double getQty() {
        return this.qty;
    }

    public abstract Object getOriginator();

    @Override
    protected void preSetPlan() {
        Plan oldPlan = this.getPlan();
        if (oldPlan != null) {
            oldPlan.getStoreSchedule(this.getStoreType()).removeActivity(this);
        }
    }

    @Override
    protected void postSetPlan() {
        Plan plan = this.getPlan();
        if (plan != null) {
            plan.getStoreSchedule(this.getStoreType()).addActivity(this);
        }
    }

    public final String toString() {
        Comparable<Long> otime = Activity.convertDatesInToString ? new Date(this.getTime()) : Long.valueOf(this.getTime());
        return String.format("%s(time=%s, st=%s, mat=%s, q=%f%s)", new Object[]{this.getClass().getSimpleName(), otime, this.storeType, this.material, this.getQty(), this.toStringAdditional()});
    }

    protected String toStringAdditional() {
        return "";
    }

    public static Comparator<StoreActivity> timeQtyRevComparator() {
        return TIME_QTY_REV_COMPARATOR;
    }
}

